# Agentic AI Course

**Introduced by:** [[Pete Kaminski]] | **Depth:** Deep thread

Pete's plan for the next two months: a 6-week course on agentic AI, compressed from 12 weeks, priced at $800, with 20 seats across two tracks.

## The Conversation

Pete shared his screen to show the course site (learn.peterkaminski.ai, not yet public at the time of the call). He described the curriculum:

1. Set up Claude Code in Obsidian
2. Learn Git / version control / snapshots
3. Real project work
4. Project management
5. Write a full-blown novel with agentic AI (stress test)
6. Build a call wiki (like this one)

> **Pete:** "This is actually literally what I want to do. I love showing you, brother, how to use Claude Code... that's what I love."

The course emerged from "Cohort Zero" — Pete informally teaching 5 people (including The Nameless One, [[Wendy Elford]], and Matthew) how to use [[Claude Code]] with Obsidian.

## Victoria's Feedback

[[Victoria]] gave feedback that both delayed and improved the course. She challenged Pete on two fronts:

1. **Compression:** "Pete, you're compressing it too much." Pete acknowledged this but felt the first cohort could handle it.
2. **Async potential:** Victoria pushed for a written, asynchronous version. Pete needed live students for motivation but agreed the async version should come in cohort 2 or 3.

Victoria offered a trade: a seat in exchange for TA work and help preparing async materials.

## The Novel Controversy

> **Pete:** "One person who has spent years writing her own novel, she was pretty offended by this. She's like, Pete, this completely devalues the whole process of writing and thinking."

Pete clarified: "The reason I wrote a full-blown novel was not because I think it's a great novel, but it was like a stress test — hey, Claude Code, how big can you get? How deep can you go?" This was actually [[Victoria]]'s reaction.

## The TA / Co-op Pattern

Pete extended the Victoria trade pattern to others:

> **Pete:** "Brother, I was thinking of you, you would be an awesome TA for this course, too. TA is not the right word, but it conveys it quickly enough."

[[The Nameless One]] reframed this powerfully:

> **The Nameless One:** "I don't think you want me to be a TA. You want me to be as much of me as I can be."

He proposed seeing the arrangement as an emergent co-op:

> **The Nameless One:** "You're really building an emergent cooperative... Maybe this becomes our thing rather than Pete's thing."

People offered/considering the steward role: [[Victoria]], [[Jessie Upp]], [[The Nameless One]], [[Charles Blass]]. Pete noted that 5-6 stewards out of 20 students "is a lot... although holding the space for the whole thing working, it's actually probably perfect."

## The AI Coaching Forum Ghost

Pete admitted vulnerability:

> **Pete:** "I enacted that pattern, a year ago, with a group of really great people. And we didn't get it off the ground. And it collapsed, and it actually hurt a fair bit."

See [[AI Coaching Forum]].

## Economics

- Street value: ~$2,000
- Launch price: $800
- If half the 20 seats fill, Pete would be "pretty happy"
- This is Pete's planned income for the next 2 months

## Related

- [[Claude Code]] — the primary tool taught in the course
- [[Victoria]] — TA, gave pivotal feedback
- [[AI Coaching Forum]] — a previous attempt at this pattern that collapsed
- [[Circles and Emergent Organization]] — the co-op framing
- [[Nameless University]] — The Nameless One's parallel education concept
- [[Pete Kaminski]]
